﻿using System;
//using System.Collections.Generic;
//using System.Text;
using System.IO;
using System.Windows.Forms;
using Dizplay_Cruise;

namespace Dizplay_Cruise
{
    class Globals
    {
        public static readonly string nl = Environment.NewLine;
        public static readonly string dnl = nl + nl;

        #region Files and folders

        public static readonly string DataFolder = Path.Combine(Application.StartupPath, "Dizplay");
        public static readonly string ApplicationFolder = Path.Combine(DataFolder, "Cruise");
        public static readonly string ConfigBackupFolder = Path.Combine(ApplicationFolder, "Global Config Backup");

        static public readonly string ConfigFile = Path.Combine(ApplicationFolder, "globalConfig.dz");
        static public readonly string RunningFile = Path.Combine(ApplicationFolder, "runningFile.dz");
        static public readonly string UserMarksFile = Path.Combine(ApplicationFolder, "userMarks.dz");
        static public readonly string SpecialSymbolsFile = Path.Combine(ApplicationFolder, "specSymb.dz");
        static public readonly string ConfigBackupFile = Path.Combine(ApplicationFolder, "globalConfigBackup(" + System.DateTime.Now + ").dz");

        public static Helpers.ItObj StartupFileFolderCheck()
        {
            clsHistory H = new clsHistory();
            H.Title = new Helpers.ItObj("File folder startup existance check + creation", Form1.History.Count);

            if (!Directory.Exists(DataFolder))
            {
                Directory.CreateDirectory(DataFolder);
                H.Text += "Directory created: DataFolder" + nl;
            }

            if (!Directory.Exists(ApplicationFolder))
            {
                Directory.CreateDirectory(ApplicationFolder);
                H.Text += "Directory created: ApplicationFolder" + nl;
            }

            if (!Directory.Exists(ConfigBackupFolder))
            {
                Directory.CreateDirectory(ConfigBackupFolder);
                H.Text += "Directory created: ConfigBackupFolder" + nl;
            }

            if (!File.Exists(ConfigFile))
            {
                File.Create(ConfigFile);
                H.Text += "File created: ConfigFile" + nl;
            }

            if (!File.Exists(RunningFile))
            {
                File.Create(RunningFile);
                H.Text += "File created: RunningFile" + nl;
            }

            if (!File.Exists(UserMarksFile))
            {
                File.Create(UserMarksFile);
                H.Text += "File created: UserMarksFile" + nl;
            }

            if (!File.Exists(SpecialSymbolsFile))
            {
                File.Create(SpecialSymbolsFile);
                H.Text += "File created: SpecialSymbolsFile" + nl;
            }

            H.Text += "-- Check completed --";

            Form1.History.Add(H);
            return H.Title;
        }

        #endregion

        //Internet Protocol
        public static string rootIP = "127.0.0.1";
        //Administration Password
        public static string rootAP = "";
        //Port
        public static ushort rootPT = 29999;
        //Auto Connect
        public static bool rootAC = false;
        //MCI Interval
        public static ushort rootMI = 500;
    }
}
